<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage config
* @filesource
*//** */

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = 'auth'; //by default, send the user to the login screen
$route['404_override'] = 'errors';

/*Admin Panel Routes */
$route['adminpanel/distribution_lists/removed'] = 'adminpanel/distribution_lists_removed';
$route['adminpanel/distribution_lists/create'] = 'adminpanel/create_distribution_list';
$route['adminpanel/distribution_lists/page/(:any)'] = 'adminpanel/paginate_distribution_lists/$1';
$route['adminpanel/distribution_lists/removed/page/(:any)'] = 'adminpanel/paginate_distribution_lists_removed/$1';
$route['adminpanel/distribution_lists/list/(:any)'] = 'adminpanel/distribution_lists_edit/$1';
$route['adminpanel/distribution_lists/removed/list/(:any)'] = 'adminpanel/distribution_lists_edit_removed/$1';

$route['adminpanel/manage_groups'] = 'admin_panel/group_controller/index';
$route['adminpanel/manage_groups/page/(:num)'] = 'admin_panel/group_controller/index/$1';
$route['adminpanel/manage_groups/(:any)'] = 'admin_panel/group_controller/$1';
$route['adminpanel/manage_groups/(:any)/(:any)'] = 'admin_panel/group_controller/$1/$2';
$route['adminpanel/manage_groups/(:any)/(:any)/(:any)'] = 'admin_panel/group_controller/$1/$2/$3';

/* INBOX ROUTES */

/* Attachments */
$route['inbox/compose/draft/(:num)/attach/patient_document'] = 'mailbox/attachment_controller/patient_id_form/$1';
$route['inbox/attach'] = 'mailbox/attachment_controller/attach/$1';
$route['inbox/attachment/(:any)/description'] = 'mailbox/attachment_controller/ajax_attachment_description/$1';
$route['inbox/get_attachment/(:num)/(:any)'] = 'mailbox/attachment_controller/get_attachment/$1/$2';
$route['inbox/get_attachment/(:num)/(:any)/(:any)'] = 'mailbox/attachment_controller/get_attachment/$1/$2/$3';
$route['inbox/get_attachment/(:num)/(:any)/(:any)/(:any)'] = 'mailbox/attachment_controller/get_attachment/$1/$2/$3/$4';
$route['inbox/imgdisp/(:num)/(:any)'] = 'mailbox/attachment_controller/imgdisp/$1/$2';
$route['inbox/imgdisp/(:num)/(:any)/(:any)'] = 'mailbox/attachment_controller/imgdisp/$1/$2/$3';

$route['inbox/(clear_attachment|preview_attachment)/(:any)'] = 'mailbox/attachment_controller/$1/$2';

$route['inbox/message/(:num)/attachment/(:any)/save_to_das'] = 'mailbox/attachment_controller/save_to_das/$1/$2/';

/* Distribution Lists */
$route['inbox/(edit_list|remove_list)/(:num)/(:any)'] = 'mailbox/distribution_list_controller/$1/$2';
$route['inbox/(edit_list|remove_list)/(:num)'] = 'mailbox/distribution_list_controller/$1/$2';
$route['inbox/(create_list|edit_distribution_list)/(:any)'] = 'mailbox/distribution_list_controller/$1/$2';
$route['inbox/(create_list|edit_distribution_list)'] = 'mailbox/distribution_list_controller/$1';

/* Flags */
$route['inbox/save_flag_message'] = 'mailbox/flag_controller/save_flag_message';

/* Folders */
$route['inbox/(archive_folder|create_folder|create_folder_form|rename_folder)/(:any)'] = 'mailbox/folder_controller/$1/$2';
$route['inbox/(archive_folder|create_folder|create_folder_form|rename_folder)'] = 'mailbox/folder_controller/$1';

/* Messages */
$route['inbox/ajax_draft_save'] = 'mailbox/message_controller/ajax_draft_save';
$route['inbox/(archive|viewmsg)/(:num)'] = 'mailbox/message_controller/$1/$2';
$route['inbox/compose'] = 'mailbox/message_controller/compose';
$route['inbox/compose/(draft|forward|reply|replyall)'] = 'mailbox/message_controller/compose/$1';
$route['inbox/compose/(draft|forward|reply|replyall)/(:num)'] = 'mailbox/message_controller/compose/$1/$2';
$route['inbox/compose/draft/(:num)/purpose_of_disclosure'] = 'mailbox/message_controller/purpose_of_disclosure/$1';
/*$route['inbox/compose'] = 'mailbox/message_controller/compose';
$route['inbox/compose/(draft|forward|reply|replyall)'] = 'mailbox/message_controller/compose/$1';
$route['inbox/compose/(draft|forward|reply|replyall)/(:num)'] = 'mailbox/message_controller/compose/$1/$2'; */
$route['inbox/(mark_as_read|mark_as_unread)'] = 'mailbox/message_controller/$1';
$route['inbox/move/(move|move_hidden|inbox)'] = 'mailbox/message_controller/move/$1';

/* Workflow */
$route['inbox/assign_message_status/(:any)/(:num)/(:any)'] = 'mailbox/workflow_controller/assign_message_status/$1/$2';
$route['inbox/assign_message_status/(:any)/(:num)'] = 'mailbox/workflow_controller/assign_message_status/$1/$2';
$route['inbox/(assign_to_me|complete_message|reset_message_status)/(:any)/(:num)/(:any)'] = 'mailbox/workflow_controller/$1/$2/$3';
$route['inbox/(assign_to_me|complete_message|reset_message_status)/(:any)/(:num)'] = 'mailbox/workflow_controller/$1/$2/$3';
$route['inbox/(assign_to_me|complete_message|reset_message_status)/(:any)/(:any)'] = 'mailbox/workflow_controller/$1/$2';
$route['inbox/(assign_to_me|complete_message|reset_message_status)/(:any)'] = 'mailbox/workflow_controller/$1/$2';


/* End of file routes.php */
/* Location: ./application/config/routes.php */